/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crusher;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.crusher.CrushingWheelControllerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class CrushingWheelControllerBlockEntity
extends SmartBlockEntity
implements SidedStorageBlockEntity {
    public class_1297 processingEntity;
    private UUID entityUUID;
    protected boolean searchForEntity;
    public ProcessingInventory inventory = new ProcessingInventory(this::itemInserted){

        @Override
        public boolean isItemValid(int slot, ItemVariant stack, int amount) {
            return super.isItemValid(slot, stack, amount) && CrushingWheelControllerBlockEntity.this.processingEntity == null;
        }
    };
    public float crushingspeed;

    public CrushingWheelControllerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::supportsDirectBeltInput));
    }

    private boolean supportsDirectBeltInput(class_2350 side) {
        class_2680 blockState = this.method_11010();
        if (blockState == null) {
            return false;
        }
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)CrushingWheelControllerBlock.field_10927);
        return direction == class_2350.field_11033 || direction == side;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.searchForEntity) {
            this.searchForEntity = false;
            List search = this.field_11863.method_8333((class_1297)null, new class_238(this.method_11016()), e -> this.entityUUID.equals(e.method_5667()));
            if (search.isEmpty()) {
                this.clear();
            } else {
                this.processingEntity = (class_1297)search.get(0);
            }
        }
        if (!this.isOccupied()) {
            return;
        }
        if (this.crushingspeed == 0.0f) {
            return;
        }
        if (this.field_11863.field_9236) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.tickAudio());
        }
        float speed = this.crushingspeed * 4.0f;
        class_243 centerPos = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)CrushingWheelControllerBlock.field_10927);
        int offset = facing.method_10171().method_10181();
        class_243 outSpeed = new class_243((facing.method_10166() == class_2350.class_2351.field_11048 ? 0.25 : 0.0) * (double)offset, offset == 1 ? (facing.method_10166() == class_2350.class_2351.field_11052 ? 0.5 : 0.0) : 0.0, (facing.method_10166() == class_2350.class_2351.field_11051 ? 0.25 : 0.0) * (double)offset);
        class_243 outPos = centerPos.method_1031((double)(facing.method_10166() == class_2350.class_2351.field_11048 ? 0.55f * (float)offset : 0.0f), (double)(facing.method_10166() == class_2350.class_2351.field_11052 ? 0.55f * (float)offset : 0.0f), (double)(facing.method_10166() == class_2350.class_2351.field_11051 ? 0.55f * (float)offset : 0.0f));
        if (!this.hasEntity()) {
            class_2338 nextPos;
            DirectBeltInputBehaviour behaviour;
            float processingSpeed = class_3532.method_15363((float)(speed / (!this.inventory.appliedRecipe ? (float)Math.log(this.inventory.getStackInSlot(0).method_7947()) / (float)Math.log(2.0) : 1.0f)), (float)0.25f, (float)20.0f);
            this.inventory.remainingTime -= processingSpeed;
            this.spawnParticles(this.inventory.getStackInSlot(0));
            if (this.field_11863.field_9236) {
                return;
            }
            if (this.inventory.remainingTime < 20.0f && !this.inventory.appliedRecipe) {
                this.applyRecipe();
                this.inventory.appliedRecipe = true;
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 18);
                return;
            }
            if (this.inventory.remainingTime > 0.0f) {
                return;
            }
            this.inventory.remainingTime = 0.0f;
            if (facing != class_2350.field_11036 && (behaviour = BlockEntityBehaviour.get((class_1922)this.field_11863, nextPos = this.field_11867.method_10074().method_10079(facing, facing.method_10166() == class_2350.class_2351.field_11052 ? 0 : 1), DirectBeltInputBehaviour.TYPE)) != null) {
                boolean changed = false;
                if (!behaviour.canInsertFromSide(facing)) {
                    return;
                }
                for (int slot = 0; slot < this.inventory.getSlotCount(); ++slot) {
                    class_1799 remainder;
                    class_1799 stack = this.inventory.getStackInSlot(slot);
                    if (stack.method_7960() || class_1799.method_7973((class_1799)stack, (class_1799)(remainder = behaviour.handleInsertion(stack, facing, false)))) continue;
                    this.inventory.setStackInSlot(slot, remainder);
                    changed = true;
                }
                if (changed) {
                    this.method_5431();
                    this.sendData();
                }
                return;
            }
            for (int slot = 0; slot < this.inventory.getSlotCount(); ++slot) {
                class_1799 stack = this.inventory.getStackInSlot(slot);
                if (stack.method_7960()) continue;
                class_1542 entityIn = new class_1542(this.field_11863, outPos.field_1352, outPos.field_1351, outPos.field_1350, stack);
                entityIn.method_18799(outSpeed);
                entityIn.getCustomData().method_10566("BypassCrushingWheel", (class_2520)class_2512.method_10692((class_2338)this.field_11867));
                this.field_11863.method_8649((class_1297)entityIn);
            }
            this.inventory.clear();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 18);
            return;
        }
        if (!this.processingEntity.method_5805() || !this.processingEntity.method_5829().method_994(new class_238(this.field_11867).method_1014(0.5))) {
            this.clear();
            return;
        }
        double xMotion = ((double)((float)this.field_11867.method_10263() + 0.5f) - this.processingEntity.method_23317()) / 2.0;
        double zMotion = ((double)((float)this.field_11867.method_10260() + 0.5f) - this.processingEntity.method_23321()) / 2.0;
        if (this.processingEntity.method_5715()) {
            zMotion = 0.0;
            xMotion = 0.0;
        }
        double movement = Math.max(-speed / 4.0f, -0.5f) * (float)(-offset);
        this.processingEntity.method_18799(new class_243(facing.method_10166() == class_2350.class_2351.field_11048 ? movement : xMotion, facing.method_10166() == class_2350.class_2351.field_11052 ? movement : 0.0, facing.method_10166() == class_2350.class_2351.field_11051 ? movement : zMotion));
        if (this.field_11863.field_9236) {
            return;
        }
        class_1297 class_12972 = this.processingEntity;
        if (!(class_12972 instanceof class_1542)) {
            class_243 entityOutPos = outPos.method_1031(facing.method_10166() == class_2350.class_2351.field_11048 ? (double)(0.5f * (float)offset) : 0.0, facing.method_10166() == class_2350.class_2351.field_11052 ? (double)(0.5f * (float)offset) : 0.0, facing.method_10166() == class_2350.class_2351.field_11051 ? (double)(0.5f * (float)offset) : 0.0);
            int crusherDamage = (Integer)AllConfigs.server().kinetics.crushingDamage.get();
            if (this.processingEntity instanceof class_1309 && ((class_1309)this.processingEntity).method_6032() - (float)crusherDamage <= 0.0f && ((class_1309)this.processingEntity).field_6235 <= 0) {
                this.processingEntity.method_5814(entityOutPos.field_1352, entityOutPos.field_1351, entityOutPos.field_1350);
            }
            this.processingEntity.method_5643(CreateDamageSources.crush(this.field_11863), (float)crusherDamage);
            if (!this.processingEntity.method_5805()) {
                this.processingEntity.method_5814(entityOutPos.field_1352, entityOutPos.field_1351, entityOutPos.field_1350);
            }
            return;
        }
        class_1542 itemEntity = (class_1542)class_12972;
        itemEntity.method_6982(20);
        if (facing.method_10166() == class_2350.class_2351.field_11052) {
            if (this.processingEntity.method_23318() * (double)(-offset) < (centerPos.field_1351 - 0.25) * (double)(-offset)) {
                this.intakeItem(itemEntity);
            }
        } else if (facing.method_10166() == class_2350.class_2351.field_11051) {
            if (this.processingEntity.method_23321() * (double)(-offset) < (centerPos.field_1350 - 0.25) * (double)(-offset)) {
                this.intakeItem(itemEntity);
            }
        } else if (this.processingEntity.method_23317() * (double)(-offset) < (centerPos.field_1352 - 0.25) * (double)(-offset)) {
            this.intakeItem(itemEntity);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        float pitch = class_3532.method_15363((float)(this.crushingspeed / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        if (this.entityUUID == null && this.inventory.getStackInSlot(0).method_7960()) {
            return;
        }
        SoundScapes.play(SoundScapes.AmbienceGroup.CRUSHING, this.field_11867, pitch);
    }

    private void intakeItem(class_1542 itemEntity) {
        this.inventory.clear();
        this.inventory.setStackInSlot(0, itemEntity.method_6983().method_7972());
        this.itemInserted(this.inventory.getStackInSlot(0));
        itemEntity.method_31472();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 18);
    }

    protected void spawnParticles(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        Object particleData = null;
        particleData = stack.method_7909() instanceof class_1747 ? new class_2388(class_2398.field_11217, ((class_1747)stack.method_7909()).method_7711().method_9564()) : new class_2392(class_2398.field_11218, stack);
        class_5819 r = this.field_11863.field_9229;
        for (int i = 0; i < 4; ++i) {
            this.field_11863.method_8406((class_2394)particleData, (double)((float)this.field_11867.method_10263() + r.method_43057()), (double)((float)this.field_11867.method_10264() + r.method_43057()), (double)((float)this.field_11867.method_10260() + r.method_43057()), 0.0, 0.0, 0.0);
        }
    }

    private void applyRecipe() {
        Optional<ProcessingRecipe<class_1263>> recipe = this.findRecipe();
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        if (recipe.isPresent()) {
            class_1799 input = this.inventory.getStackInSlot(0);
            int rolls = input.method_7947();
            this.inventory.clear();
            for (int roll = 0; roll < rolls; ++roll) {
                List<class_1799> rolledResults = recipe.get().rollResults();
                for (class_1799 stack : rolledResults) {
                    ItemHelper.addToList(stack, list);
                }
            }
            class_1799 remainder = input.getRecipeRemainder();
            if (!remainder.method_7960()) {
                ItemHelper.addToList(remainder, list);
            }
            for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlotCount(); ++slot) {
                this.inventory.setStackInSlot(slot + 1, (class_1799)list.get(slot));
            }
        } else {
            this.inventory.clear();
        }
    }

    public Optional<ProcessingRecipe<class_1263>> findRecipe() {
        Optional<ProcessingRecipe<Object>> crushingRecipe = AllRecipeTypes.CRUSHING.find(this.inventory, this.field_11863);
        if (!crushingRecipe.isPresent()) {
            crushingRecipe = AllRecipeTypes.MILLING.find(this.inventory, this.field_11863);
        }
        return crushingRecipe;
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        if (this.hasEntity()) {
            compound.method_10566("Entity", (class_2520)class_2512.method_25929((UUID)this.entityUUID));
        }
        compound.method_10566("Inventory", NBTSerializer.serializeNBT((Object)((Object)this.inventory)));
        compound.method_10548("Speed", this.crushingspeed);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.method_10545("Entity") && !this.isOccupied()) {
            this.entityUUID = class_2512.method_25930((class_2520)NBTHelper.getINBT((class_2487)compound, (String)"Entity"));
            this.searchForEntity = true;
        }
        this.crushingspeed = compound.method_10583("Speed");
        this.inventory.deserializeNBT(compound.method_10562("Inventory"));
    }

    public void startCrushing(class_1297 entity) {
        this.processingEntity = entity;
        this.entityUUID = entity.method_5667();
    }

    private void itemInserted(class_1799 stack) {
        Optional<ProcessingRecipe<class_1263>> recipe = this.findRecipe();
        this.inventory.remainingTime = recipe.isPresent() ? (float)recipe.get().getProcessingDuration() : 100.0f;
        this.inventory.appliedRecipe = false;
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return this.inventory;
    }

    public void clear() {
        this.processingEntity = null;
        this.entityUUID = null;
    }

    public boolean isOccupied() {
        return this.hasEntity() || !this.inventory.method_5442();
    }

    public boolean hasEntity() {
        return this.processingEntity != null;
    }
}

